<?php
/*
 * Contain all shortcodes for WooCommerce page builder
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit(); // Exit if accessed directly
}
$text_align_options = array( 
	esc_html__( 'Left', 'js_composer' ) => 'left', 
	esc_html__( 'Right', 'js_composer' ) => 'right', 
	esc_html__( 'Center', 'js_composer' ) => 'center', 
	esc_html__( 'Justify', 'js_composer' ) => 'justify' );
$show_hide_values = array( 
	esc_html__( 'Show', 'dt_woocommerce_page_builder' ) => 'show', 
	esc_html__( 'Hide', 'dt_woocommerce_page_builder' ) => 'hide' );
$order_by_values = array( 
	'', 
	esc_html__( 'Date', 'js_composer' ) => 'date', 
	esc_html__( 'Order by post ID', 'js_composer' ) => 'ID', 
	esc_html__( 'Author', 'js_composer' ) => 'author', 
	esc_html__( 'Title', 'js_composer' ) => 'title', 
	esc_html__( 'Last modified date', 'js_composer' ) => 'modified', 
	esc_html__( 'Random order', 'js_composer' ) => 'rand', 
	esc_html__( 'Number of comments', 'js_composer' ) => 'comment_count', 
	esc_html__( 'Menu order', 'dt_woocommerce_page_builder' ) => 'menu_order' );

$order_way_values = array( 
	'', 
	esc_html__( 'Descending', 'js_composer' ) => 'DESC', 
	esc_html__( 'Ascending', 'js_composer' ) => 'ASC' );

// My Account page builder
vc_map( 
	array( 
		"name" =>esc_html__( "My Account Dashboard", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_woocommerce_myaccount_dashboard", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		'description' =>esc_html__( 'Shows account dashboard.', 'dt_woocommerce_page_builder' ), 
		"params" => array( 
			array( 
				'type' => 'textarea_html', 
				'heading' =>esc_html__( 'Custom My Account Dashboard', 'dt_woocommerce_page_builder' ), 
				'value' => '', 
				'save_always' => true, 
				'param_name' => 'content', 
				'description' =>esc_html__( 
					'Overridden woocommerce/myaccount/dashboard.php. Leave blank to use the template dashboard.php file', 
					'dt_woocommerce_page_builder' ) ), 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );

vc_map( 
	array( 
		"name" =>esc_html__( "My Account Orders", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_woocommerce_myaccount_orders", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		'description' =>esc_html__( 'Shows orders on the account page.', 'dt_woocommerce_page_builder' ), 
		"params" => array( 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );

/*
 * Support WooCommerce Memberships
 * Sell memberships that provide access to restricted content, products, discounts, and more!
 * By: WooCommerce
 * Author: SkyVerge
 * Author URI: https://www.woocommerce.com/
 */
if ( class_exists( 'WC_Memberships_Loader' ) ) {
	vc_map( 
		array( 
			"name" =>esc_html__( "WC Memberships: My Account Memberships", 'dt_woocommerce_page_builder' ), 
			"base" => "dtwpb_woocommerce_myaccount_wc_memberships", 
			"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
			"icon" => "dt-vc-icon-dt_woo", 
			'description' =>esc_html__( 'Renders the members area content.', 'dt_woocommerce_page_builder' ), 
			"params" => array( 
				array( 
					"type" => "textfield", 
					"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
					"param_name" => "el_class", 
					'value' => '', 
					"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
				array( 
					'type' => 'css_editor', 
					'heading' => esc_html__( 'CSS box', 'js_composer' ), 
					'param_name' => 'css', 
					'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
}

if ( class_exists( 'WC_Subscriptions' ) ) {
	vc_map( 
		array( 
			"name" =>esc_html__( "WC Subscriptions: My Account Subscriptions", 'dt_woocommerce_page_builder' ), 
			"base" => "dtwpb_woocommerce_account_subscriptions_endpoint", 
			"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
			"icon" => "dt-vc-icon-dt_woo", 
			'description' => '', 
			"params" => array( 
				array( 
					"type" => "textfield", 
					"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
					"param_name" => "el_class", 
					'value' => '', 
					"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
				array( 
					'type' => 'css_editor', 
					'heading' => esc_html__( 'CSS box', 'js_composer' ), 
					'param_name' => 'css', 
					'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
} // Class WC_Subscriptions

if ( class_exists( 'WC_Bookings' ) ) {
	vc_map( 
		array( 
			"name" =>esc_html__( "WooCommerce Bookings", 'dt_woocommerce_page_builder' ), 
			"base" => "dtwpb_woocommerce_account_bookings_endpoint", 
			"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
			"icon" => "dt-vc-icon-dt_woo", 
			'description' => '', 
			"params" => array( 
				array( 
					"type" => "textfield", 
					"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
					"param_name" => "el_class", 
					'value' => '', 
					"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
				array( 
					'type' => 'css_editor', 
					'heading' => esc_html__( 'CSS box', 'js_composer' ), 
					'param_name' => 'css', 
					'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
} // Class WC_Bookings

vc_map( 
	array( 
		"name" =>esc_html__( "My Account Downloads", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_woocommerce_myaccount_downloads", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		'description' =>esc_html__( 'Shows orders on the account page.', 'dt_woocommerce_page_builder' ), 
		"params" => array( 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );

vc_map( 
	array( 
		"name" =>esc_html__( "My Account Addresses", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_woocommerce_myaccount_addresses", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		'description' =>esc_html__( 'My Addresses.', 'dt_woocommerce_page_builder' ), 
		"params" => array (
		/*array(
			'type' => 'textarea_html',
			'heading' =>esc_html__( 'Custom My Account Addresses Description', 'dt_woocommerce_page_builder' ),
			'value' => '',
			'save_always' => true,
			'param_name' => 'content',
			'description' =>esc_html__( 'filter woocommerce_my_account_my_address_description', 'dt_woocommerce_page_builder' ),
		),*/
		array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );

vc_map( 
	array( 
		"name" =>esc_html__( "My Account Details", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_woocommerce_myaccount_edit_account", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		'description' =>esc_html__( 'Edit account form.', 'dt_woocommerce_page_builder' ), 
		"params" => array( 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );

vc_map( 
	array( 
		"name" =>esc_html__( "My Account Payment methods", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_woocommerce_myaccount_payment_methods", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		'description' =>esc_html__( 'Edit account form.', 'dt_woocommerce_page_builder' ), 
		"params" => array( 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
/*
 * vc_map(
 * array(
 * "name" =>esc_html__( "My Account Add Payment method", 'dt_woocommerce_page_builder' ),
 * "base" => "dtwpb_woocommerce_myaccount_add_payment_method",
 * "category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ),
 * "icon" => "dt-vc-icon-dt_woo",
 * 'description' =>esc_html__( 'Edit account form.', 'dt_woocommerce_page_builder' ),
 * "params" => array(
 * array(
 * "type" => "textfield",
 * "heading" => esc_html__( 'Extra class name', 'js_composer' ),
 * "param_name" => "el_class",
 * 'value' => '',
 * "description" =>esc_html__(
 * "If you wish to style particular content element differently, then use this field to add a class name and then refer
 * to it in your css file.",
 * 'dt_woocommerce_page_builder' ) ),
 * array(
 * 'type' => 'css_editor',
 * 'heading' => esc_html__( 'CSS box', 'js_composer' ),
 * 'param_name' => 'css',
 * 'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
 */

vc_map( 
	array( 
		"name" =>esc_html__( "My Account Extra Endpoint", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_woocommerce_myaccount_extra_endpoint", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		'description' => '', 
		"params" => array( 
			array( 
				"type" => "textfield", 
				"heading" =>esc_html__( "Extra Key endpoint", 'dt_woocommerce_page_builder' ), 
				"param_name" => "extra_key", 
				'value' => 'bookings', 
				"description" =>esc_html__( 
					"Enter extra key for Account endpoint. eg: 'extra-key' for 'woocommerce_account_extra-key_endpoint', 'bookings' for 'woocommerce_account_bookings_endpoint'.", 
					'dt_woocommerce_page_builder' ) ), 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
vc_map( 
	array( 
		"name" =>esc_html__( "My Account Logout", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_woocommerce_myaccount_logout", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		'description' => '', 
		"params" => array( 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
